/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.capabilities.effect.EffectDataProvider;
import it.hurts.metallurgy_reforged.capabilities.effect.PlayerEffectData;
import it.hurts.metallurgy_reforged.capabilities.effect.ProgressiveDataBundle;
import it.hurts.metallurgy_reforged.config.EffectTweaksConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EtheriumArmorEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    private static final Set<String> blockBlacklist = Arrays.stream(EffectTweaksConfig.etheriumEffectArmorBlacklist).collect(Collectors.toSet());

    public EtheriumArmorEffect() {
        super(ModMetals.ETHERIUM);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @Override
    public void onStep(World world, EntityPlayer entity, ItemStack effectStack, int maxSteps, int step) {
        if (step == maxSteps) {
            entity.field_70145_X = false;
            assert (this.metal.getArmorSet() != null);
            for (ItemArmorBase armorItem : this.metal.getArmorSet()) {
                entity.func_184811_cZ().func_185145_a((Item)armorItem, 400);
            }
        }
    }

    @SubscribeEvent
    public void livingEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer entity = (EntityPlayer)event.getEntityLiving();
            if (!entity.func_70093_af() || !this.canBeApplied((EntityLivingBase)entity)) {
                return;
            }
            if (entity.func_184811_cZ().func_185143_a(this.getArmorRepr((EntityLivingBase)entity).func_77973_b(), 0.0f) != 0.0f) {
                return;
            }
            ProgressiveDataBundle bundle = ((PlayerEffectData)entity.getCapability(EffectDataProvider.PLAYER_EFFECT_DATA_CAPABILITY, null)).etheriumArmorBundle;
            AxisAlignedBB box = entity.func_174813_aQ().func_72314_b(0.1, 0.0, 0.1);
            List collisions = entity.field_70170_p.func_184144_a((Entity)entity, box);
            if (!collisions.isEmpty()) {
                if (!bundle.isEffectInProgress()) {
                    bundle.setPaused(false, entity);
                }
                if (!bundle.isEffectInProgress()) {
                    bundle.incrementStep(entity);
                }
                entity.field_70145_X = true;
                entity.field_70181_x = 0.0;
            } else {
                bundle.setPaused(true, entity);
            }
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = (int)box.field_72340_a; x <= MathHelper.func_76143_f((double)box.field_72336_d); ++x) {
                for (int y = entity.func_180425_c().func_177956_o(); y <= MathHelper.func_76143_f((double)box.field_72337_e); ++y) {
                    for (int z = (int)box.field_72339_c; z <= MathHelper.func_76143_f((double)box.field_72334_f); ++z) {
                        pos.func_181079_c(x, y, z);
                        if (!box.func_186668_a((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0) || !blockBlacklist.contains(entity.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c().getRegistryName().toString())) continue;
                        Vec3d vec = entity.func_174791_d().func_178786_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5).func_72432_b();
                        double velocity = 0.1;
                        entity.field_70133_I = true;
                        entity.field_70159_w += vec.field_72450_a * velocity;
                        entity.field_70179_y += vec.field_72449_c * velocity;
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void setupFogWhileInsideBlocks(EntityViewRenderEvent.RenderFogEvent event) {
        Entity entity = event.getEntity();
        if (entity.func_70093_af() && entity instanceof EntityLivingBase && this.canBeApplied((EntityLivingBase)entity) && !entity.field_70170_p.func_184144_a(entity, entity.func_174813_aQ()).isEmpty()) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
            GlStateManager.func_179095_a((float)0.25f);
        }
    }
}

