/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ElectrumArmorEffect
extends BaseMetallurgyEffect {
    public ElectrumArmorEffect() {
        super(ModMetals.ELECTRUM);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void chargeItemsOnHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            int level = this.getLevel((EntityLivingBase)player);
            if (level == 0) {
                return;
            }
            NonNullList energyStacks = NonNullList.func_191196_a();
            player.field_71071_by.field_70462_a.forEach(stack -> {
                IEnergyStorage itemCap = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                if (itemCap != null && itemCap.canReceive()) {
                    energyStacks.add(stack);
                }
            });
            int maxEnergy = 7000 + (level - 1) * 3000;
            float energy = (1.0f - (player.func_110143_aJ() - event.getAmount()) / player.func_110138_aP()) * (float)maxEnergy;
            float distributedEnergy = energy / (float)energyStacks.size();
            energyStacks.forEach(stack -> {
                IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                assert (storage != null);
                storage.receiveEnergy(MathHelper.func_76123_f((float)distributedEnergy), false);
            });
        }
    }
}

