/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.advancement.CommonCriterionInstances;
import it.hurts.metallurgy_reforged.advancement.ModAdvancements;
import it.hurts.metallurgy_reforged.capabilities.effect.EffectDataProvider;
import it.hurts.metallurgy_reforged.capabilities.effect.PlayerEffectData;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DesichalkosArmorEffect
extends BaseMetallurgyEffect {
    public DesichalkosArmorEffect() {
        super(ModMetals.DESICHALKOS);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void updateTimeWithoutDamage(LivingEvent.LivingUpdateEvent event) {
        int level = this.getLevel(event.getEntityLiving());
        if (level == 0) {
            return;
        }
        PlayerEffectData effectData = (PlayerEffectData)event.getEntityLiving().getCapability(EffectDataProvider.PLAYER_EFFECT_DATA_CAPABILITY, null);
        if (effectData == null) {
            return;
        }
        if (effectData.desichalkosAbsorbLevel > level) {
            effectData.desichalkosAbsorbLevel = level;
        }
        if (effectData.desichalkosTimeWithoutTakingDamage < 200) {
            ++effectData.desichalkosTimeWithoutTakingDamage;
        } else if (event.getEntity().field_70173_aa % 140 == 0 && effectData.desichalkosAbsorbLevel < level) {
            event.getEntityLiving().field_70170_p.func_184133_a(null, event.getEntityLiving().func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.5f, 1.3f);
            for (int i = 0; i < 30; ++i) {
                this.spawnParticle((Entity)event.getEntityLiving(), 3.0f, true, 2);
            }
            ++effectData.desichalkosAbsorbLevel;
        }
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        PlayerEffectData effectData = (PlayerEffectData)event.getEntityLiving().getCapability(EffectDataProvider.PLAYER_EFFECT_DATA_CAPABILITY, null);
        if (effectData == null) {
            return;
        }
        if (effectData.desichalkosAbsorbLevel > 0) {
            event.setCanceled(true);
            for (int i = 0; i < 30; ++i) {
                this.spawnParticle((Entity)event.getEntityLiving(), 3.0f, true, Math.min(effectData.desichalkosAbsorbLevel * 2, 9));
            }
            --effectData.desichalkosAbsorbLevel;
            event.getEntityLiving().field_70170_p.func_184133_a(null, event.getEntityLiving().func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.5f, 0.3f);
            if (event.getEntityLiving() instanceof EntityPlayerMP) {
                ModAdvancements.Triggers.LOYAL_FRIENDS.trigger((EntityPlayerMP)event.getEntityLiving(), new CommonCriterionInstances.AlwaysTrue(ModAdvancements.Triggers.LOYAL_FRIENDS.func_192163_a()));
            }
        }
        effectData.desichalkosTimeWithoutTakingDamage = 0;
    }
}

