/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.advancement.CommonCriterionInstances;
import it.hurts.metallurgy_reforged.advancement.ModAdvancements;
import it.hurts.metallurgy_reforged.capabilities.effect.ExtraFilledDataBundle;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CelenegilArmorEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    private static final int RADIUS = 5;

    public CelenegilArmorEffect() {
        super(ModMetals.CELENEGIL);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        int level = this.getLevel(event.getEntityLiving());
        if (level == 0) {
            return;
        }
        EntityPlayer entity = (EntityPlayer)event.getEntityLiving();
        ExtraFilledDataBundle data = this.getEffectCapability((EntityPlayer)entity).celenegilArmorBundle;
        int hits = data.getExtraInt("hits");
        if (hits > 4) {
            entity.func_70674_bp();
            entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 20 + 20 * level, 1));
            BlockPos entityPos = entity.func_180425_c();
            entity.field_70170_p.func_72839_b((Entity)entity, new AxisAlignedBB((double)(entityPos.func_177958_n() - 5), (double)(entityPos.func_177956_o() - 1), (double)(entityPos.func_177952_p() - 5), (double)(entityPos.func_177958_n() + 5), (double)(entityPos.func_177956_o() + 1), (double)(entityPos.func_177952_p() + 5))).forEach(enemy -> {
                Vec3d motionVec = new Vec3d(enemy.field_70165_t - entity.field_70165_t, 0.6, enemy.field_70161_v - entity.field_70161_v).func_72432_b();
                enemy.field_70159_w += motionVec.field_72450_a * 1.5;
                enemy.field_70181_x += motionVec.field_72448_b;
                enemy.field_70179_y += motionVec.field_72449_c * 1.5;
            });
            data.setExtra("hits", 0);
            if (entity instanceof EntityPlayerMP) {
                ModAdvancements.Triggers.LOYAL_FRIENDS.trigger((EntityPlayerMP)entity, new CommonCriterionInstances.AlwaysTrue(ModAdvancements.Triggers.LOYAL_FRIENDS.func_192163_a()));
            }
            for (int i = 0; i < 60; ++i) {
                this.spawnParticle(entity.field_70170_p, entityPos, 4.0f, true, 6, 0.7 - Math.random() * 1.6, 0.01, 0.7 - Math.random() * 1.6);
            }
        } else {
            data.setExtra("hits", hits + 1);
            data.setExtra("inactive", false);
        }
    }

    @Override
    public void onStep(World world, EntityPlayer player, ItemStack effectStack, int maxSteps, int step) {
        ExtraFilledDataBundle bundle = this.getEffectCapability((EntityPlayer)player).celenegilArmorBundle;
        if (step == 1 && !bundle.getExtraBool("inactive")) {
            bundle.setExtra("inactive", true);
        }
        if (step == 3 && bundle.getExtraBool("inactive")) {
            bundle.setExtra("hits", 0);
        }
    }
}

