/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.advancement.CommonCriterionInstances;
import it.hurts.metallurgy_reforged.advancement.ModAdvancements;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.all.TartariteEffect;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.network.PacketManager;
import it.hurts.metallurgy_reforged.network.client.PacketAdamantineRenderDeathProtection;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AdamantineArmorEffect
extends BaseMetallurgyEffect {
    public AdamantineArmorEffect() {
        super(ModMetals.ADAMANTINE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!this.canBeApplied(entity)) {
            return;
        }
        if (!entity.field_70170_p.field_72995_K) {
            EntityEquipmentSlot randomArmorSlot = EntityEquipmentSlot.values()[2 + Utils.random.nextInt(4)];
            ItemStack armorPiece = entity.func_184582_a(randomArmorSlot);
            if (entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).func_184811_cZ().func_185143_a(armorPiece.func_77973_b(), 0.0f) != 0.0f) {
                return;
            }
            if (ItemUtils.isMadeOfMetal(this.metal, armorPiece.func_77973_b(), new Class[0]) || TartariteEffect.getParagonMetal(armorPiece) == this.metal) {
                entity.func_184201_a(randomArmorSlot, ItemStack.field_190927_a);
                entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_191263_gW, SoundCategory.PLAYERS, 1.0f, 1.0f);
                entity.func_70606_j(1.0f);
                event.setCanceled(true);
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)entity;
                    assert (this.metal.getArmorSet() != null);
                    for (ItemArmorBase armorItem : this.metal.getArmorSet()) {
                        player.func_184811_cZ().func_185145_a((Item)armorItem, 100);
                    }
                    ModAdvancements.Triggers.LOYAL_FRIENDS.trigger(player, new CommonCriterionInstances.AlwaysTrue(ModAdvancements.Triggers.LOYAL_FRIENDS.func_192163_a()));
                    PacketAdamantineRenderDeathProtection packet = new PacketAdamantineRenderDeathProtection(entity.func_145782_y(), armorPiece);
                    CriteriaTriggers.field_193130_A.func_193187_a(player, armorPiece);
                    PacketManager.network.sendTo((IMessage)packet, player);
                    PacketManager.network.sendToAllTracking((IMessage)packet, (Entity)entity);
                }
                entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 500, 2));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 60, 1));
            }
        }
    }
}

