/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.all;

import com.google.common.collect.Multimap;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.MetallurgyEffects;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Constants;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class TartariteEffect
extends BaseMetallurgyEffect {
    public TartariteEffect() {
        super(ModMetals.TARTARITE);
        this.setupModelOverrides((stack, worldIn, entityIn) -> {
            if (stack.func_77978_p() == null) {
                return 0.0f;
            }
            Metal paragonMetal = TartariteEffect.getParagonMetal(stack);
            if (paragonMetal == null) {
                return 0.0f;
            }
            switch (paragonMetal.toString()) {
                case "celenegil": {
                    return stack.func_77978_p().func_74767_n("glory_seeker") ? 1.0f : 0.0f;
                }
                case "electrum": {
                    return stack.func_77978_p().func_74767_n("voltage_control") ? 1.0f : 0.0f;
                }
            }
            return 0.0f;
        });
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ALL;
    }

    @Override
    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull Entity entityIn, int itemSlot, boolean isSelected) {
        Metal metal = TartariteEffect.getParagonMetal(stack);
        if (metal == null) {
            return;
        }
        Map metalEffects = MetallurgyEffects.effects.row((Object)metal);
        EnumTools toolType = EnumTools.byInstance(stack.func_77973_b());
        if (toolType != null) {
            metalEffects.forEach((category, effect) -> {
                if (ArrayUtils.contains((Object[])category.getTools(), (Object)((Object)toolType))) {
                    effect.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
                }
            });
        } else if (metalEffects.get((Object)EnumEffectCategory.ARMOR) != null) {
            ((BaseMetallurgyEffect)MetallurgyEffects.effects.get((Object)metal, (Object)EnumEffectCategory.ARMOR)).inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        }
        BaseMetallurgyEffect itemEffect = (BaseMetallurgyEffect)metalEffects.get((Object)EnumEffectCategory.ALL);
        if (itemEffect != null) {
            itemEffect.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        }
    }

    @Override
    public void rightClickHandler(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Metal metal = TartariteEffect.getParagonMetal(stack);
        if (metal == null) {
            return;
        }
        EnumTools toolType = EnumTools.byInstance(stack.func_77973_b());
        if (toolType == null) {
            return;
        }
        MetallurgyEffects.effects.row((Object)metal).forEach((category, effect) -> {
            if (ArrayUtils.contains((Object[])category.getTools(), (Object)((Object)toolType))) {
                effect.rightClickHandler(worldIn, playerIn, handIn);
            }
        });
    }

    public static void setParagon(ItemStack tartarStack, @Nonnull Metal metal) {
        NBTTagCompound compound = tartarStack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        MetalStats metalStats = metal.getStats();
        compound.func_74778_a("paragon", metalStats.getName());
        compound.func_74757_a("paragon_absorbed", true);
        int infusedDurability = metalStats.getToolStats() != null ? metalStats.getToolStats().getMaxUses() : metalStats.getArmorStats().getDurability() * 16;
        float durabilityRatio = ((float)tartarStack.func_77958_k() + (float)infusedDurability) / (float)(tartarStack.func_77958_k() - infusedDurability);
        compound.func_74776_a("durability_boost", durabilityRatio);
        tartarStack.func_77982_d(compound);
        EntityEquipmentSlot slot = EntityLiving.func_184640_d((ItemStack)tartarStack);
        Multimap itemMods = tartarStack.func_77973_b().getAttributeModifiers(slot, tartarStack);
        if (slot != EntityEquipmentSlot.MAINHAND && metal.hasArmorSet()) {
            if (metalStats.getArmorStats().getMaxHealth() != 0.0) {
                ItemUtils.editOrAddModifier((Multimap<String, AttributeModifier>)itemMods, SharedMonsterAttributes.field_111267_a, Constants.ModAttributes.ARMOR_MAX_HEALTH.get(slot), metalStats.getArmorStats().getMaxHealth() / 4.0);
            }
            if (metalStats.getArmorStats().getKnockbackResistance() != 0.0) {
                ItemUtils.editOrAddModifier((Multimap<String, AttributeModifier>)itemMods, SharedMonsterAttributes.field_111266_c, Constants.ModAttributes.ARMOR_KNOCKBACK_RESISTANCE.get(slot), metalStats.getArmorStats().getKnockbackResistance() / 4.0);
            }
            if (metalStats.getArmorStats().getMovementSpeed() != 0.0) {
                ItemUtils.editOrAddModifier((Multimap<String, AttributeModifier>)itemMods, SharedMonsterAttributes.field_111263_d, Constants.ModAttributes.ARMOR_MOVEMENT_SPEED.get(slot), metalStats.getArmorStats().getMovementSpeed() / 4.0);
            }
        }
        if (slot == EntityEquipmentSlot.MAINHAND && metal.hasToolSet()) {
            if (metalStats.getToolStats().getMaxHealth() != 0.0) {
                ItemUtils.editOrAddModifier((Multimap<String, AttributeModifier>)itemMods, SharedMonsterAttributes.field_111267_a, Constants.ModAttributes.MAX_HEALTH, metalStats.getToolStats().getMaxHealth());
            }
            if (metalStats.getToolStats().getMovementSpeed() != 0.0) {
                ItemUtils.editOrAddModifier((Multimap<String, AttributeModifier>)itemMods, SharedMonsterAttributes.field_111263_d, Constants.ModAttributes.MOVEMENT_SPEED, metalStats.getToolStats().getMovementSpeed());
            }
            if (metalStats.getToolStats().getReachDistance() != 0.0) {
                ItemUtils.editOrAddModifier((Multimap<String, AttributeModifier>)itemMods, EntityPlayer.REACH_DISTANCE, Constants.ModAttributes.REACH_DISTANCE, metalStats.getToolStats().getReachDistance());
            }
        }
        itemMods.forEach((attributeName, modifier) -> tartarStack.func_185129_a(attributeName, modifier, slot));
    }

    @Nullable
    public static Metal getParagonMetal(ItemStack tartarStack) {
        NBTTagCompound compound = tartarStack.func_77978_p();
        if (compound != null) {
            return ModMetals.metalMap.get(compound.func_74779_i("paragon"));
        }
        return null;
    }
}

