/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.all;

import it.hurts.metallurgy_reforged.config.EffectsRosterConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.all.TartariteEffect;
import it.hurts.metallurgy_reforged.item.tool.IToolEffect;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.render.font.FontColor;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.Utils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class PlatinumEffect
extends BaseMetallurgyEffect {
    public PlatinumEffect() {
        super(ModMetals.PLATINUM);
    }

    @Override
    public int getLevel(EntityLivingBase entity) {
        ItemStack tool = entity.func_184614_ca();
        if (tool.func_77973_b() instanceof IToolEffect && (ItemUtils.isMadeOfMetal(this.metal, tool.func_77973_b(), IToolEffect.class) || TartariteEffect.getParagonMetal(tool) == this.metal)) {
            return 1;
        }
        return 0;
    }

    @SubscribeEvent
    public void onItemEquipped(LivingEquipmentChangeEvent event) {
        if (event.getSlot() != EntityEquipmentSlot.MAINHAND) {
            return;
        }
        if (!this.canBeApplied(event.getEntityLiving())) {
            return;
        }
        ItemStack stack = event.getTo();
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        if (!compound.func_74764_b("Unbreakable")) {
            compound.func_74768_a("Unbreakable", 1);
        }
        stack.func_77982_d(compound);
    }

    @Override
    public boolean isEnabled() {
        if (this.metal == null) {
            return false;
        }
        return EffectsRosterConfig.platinumEffectAll;
    }

    @Override
    public Pair<String, String> getTooltip() {
        String effectLangKey = "tooltip.metallurgy.effect." + this.metal.toString() + "_all";
        String name = FontColor.encodeColor(this.metal.getStats().getColorHex()) + Utils.localizeEscapingCustomSequences(effectLangKey);
        String description = Utils.localizeEscapingCustomSequences(effectLangKey + ".tooltip");
        return ImmutablePair.of((Object)name, (Object)description);
    }
}

