/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.all;

import com.google.common.collect.Multimap;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.all.TartariteEffect;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.item.tool.IToolEffect;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.render.font.FontColor;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MithrilEffect
extends BaseMetallurgyEffect {
    private static final UUID PROTECTION_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-1111033DB5CF");
    private static final UUID TOUGHNESS_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-1111133DB5CF");
    private static final UUID ATTACK_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-1111233DB5CF");
    private static final AttributeModifier ATTACK_SPEED_MODIFIER = new AttributeModifier(UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3"), "MITHRIL_Attack_Speed_Restore", (double)-2.4f, 0);

    public MithrilEffect() {
        super(ModMetals.MITHRIL);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ALL;
    }

    @SubscribeEvent
    public void armorBuffInAnvil(AnvilRepairEvent event) {
        boolean isParagonAbsorbed;
        boolean bl = isParagonAbsorbed = TartariteEffect.getParagonMetal(event.getItemInput()) == this.metal;
        if (ItemUtils.isMadeOfMetal(this.metal, event.getItemInput().func_77973_b(), ItemArmorBase.class, IToolEffect.class) || isParagonAbsorbed) {
            int outputEnchCount = event.getItemResult().func_77986_q().func_74745_c();
            this.applyCombatBuffs(event.getItemResult(), outputEnchCount, event.getItemResult().func_77973_b() instanceof ItemArmorBase);
        }
    }

    @SubscribeEvent
    public void equipmentBuff(LivingEquipmentChangeEvent event) {
        ItemStack stack = event.getTo();
        if (ItemUtils.isMadeOfMetal(this.metal, stack.func_77973_b(), ItemArmorBase.class, IToolEffect.class) || TartariteEffect.getParagonMetal(stack) == this.metal) {
            this.applyCombatBuffs(stack, stack.func_77986_q().func_74745_c(), stack.func_77973_b() instanceof ItemArmorBase);
        }
    }

    private void addEditAttributeModifier(NBTTagList modList, AttributeModifier mod, int modIndex, String attributeName, EntityEquipmentSlot applicationSlot) {
        NBTTagCompound modCompound = SharedMonsterAttributes.func_111262_a((AttributeModifier)mod);
        modCompound.func_74778_a("AttributeName", attributeName);
        modCompound.func_74778_a("Slot", applicationSlot.func_188450_d());
        if (modIndex == -1) {
            modList.func_74742_a((NBTBase)modCompound);
        } else {
            modList.func_150304_a(modIndex, (NBTBase)modCompound);
        }
    }

    private void applyCombatBuffs(ItemStack stackRef, int enchantments, boolean armor) {
        int delta;
        NBTTagCompound stackData = stackRef.func_77978_p();
        if (stackData == null) {
            stackData = new NBTTagCompound();
        }
        if ((delta = enchantments - stackData.func_74762_e("arcane_boost")) != 0) {
            int oldBoostLevel = stackData.func_74762_e("arcane_boost");
            int boostLevel = oldBoostLevel + delta;
            stackData.func_74768_a("arcane_boost", MathHelper.func_76125_a((int)boostLevel, (int)0, (int)5));
            if (!stackData.func_150297_b("AttributeModifiers", 9)) {
                stackData.func_74782_a("AttributeModifiers", (NBTBase)new NBTTagList());
            }
            int protectionIndex = -1;
            int toughnessIndex = -1;
            int attackIndex = -1;
            int attackSpeedIndex = -1;
            NBTTagList serializedModifiers = stackData.func_150295_c("AttributeModifiers", 10);
            for (int i = 0; i < serializedModifiers.func_74745_c(); ++i) {
                AttributeModifier modifier2 = SharedMonsterAttributes.func_111259_a((NBTTagCompound)serializedModifiers.func_150305_b(i));
                assert (modifier2 != null);
                if (modifier2.func_111167_a().equals(PROTECTION_UUID)) {
                    protectionIndex = i;
                    continue;
                }
                if (modifier2.func_111167_a().equals(TOUGHNESS_UUID)) {
                    toughnessIndex = i;
                    continue;
                }
                if (modifier2.func_111167_a().equals(ATTACK_UUID)) {
                    attackIndex = i;
                    continue;
                }
                if (!modifier2.func_111167_a().equals(ATTACK_SPEED_MODIFIER.func_111167_a())) continue;
                attackSpeedIndex = i;
            }
            EntityEquipmentSlot slot = EntityLiving.func_184640_d((ItemStack)stackRef);
            stackRef.func_77973_b().getAttributeModifiers(slot, stackRef).forEach((attribute, modifier) -> this.addEditAttributeModifier(serializedModifiers, (AttributeModifier)modifier, -1, (String)attribute, slot));
            if (armor) {
                AttributeModifier protMod = new AttributeModifier(PROTECTION_UUID, "MITHRIL_Armor_Protection_Buff", (double)boostLevel, 0);
                this.addEditAttributeModifier(serializedModifiers, protMod, protectionIndex, SharedMonsterAttributes.field_188791_g.func_111108_a(), slot);
                AttributeModifier toughMod = new AttributeModifier(TOUGHNESS_UUID, "MITHRIL_Armor_Toughness_Buff", (double)((float)boostLevel * 0.5f), 0);
                this.addEditAttributeModifier(serializedModifiers, toughMod, toughnessIndex, SharedMonsterAttributes.field_189429_h.func_111108_a(), slot);
            } else {
                AttributeModifier attackMod = new AttributeModifier(ATTACK_UUID, "MITHRIL_Attack_Buff", (double)(3.0f + (float)boostLevel), 0);
                this.addEditAttributeModifier(serializedModifiers, attackMod, attackIndex, SharedMonsterAttributes.field_111264_e.func_111108_a(), slot);
                this.addEditAttributeModifier(serializedModifiers, ATTACK_SPEED_MODIFIER, attackSpeedIndex, SharedMonsterAttributes.field_188790_f.func_111108_a(), slot);
            }
        }
    }

    @SubscribeEvent
    public void applyEfficiencyBuff(PlayerEvent.BreakSpeed event) {
        ItemStack tool = event.getEntityPlayer().func_184614_ca();
        if (ItemUtils.isMadeOfMetal(this.metal, tool.func_77973_b(), IToolEffect.class) || TartariteEffect.getParagonMetal(tool) == this.metal) {
            NBTTagCompound toolData = tool.func_77978_p();
            if (toolData == null) {
                return;
            }
            int buffLevel = toolData.func_74762_e("arcane_boost");
            float newSpeed = event.getOriginalSpeed() + (float)buffLevel * 1.5f;
            if (buffLevel > 0) {
                event.setNewSpeed(newSpeed);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void colorAttributeMods(ItemTooltipEvent event) {
        ItemStack stackRef = event.getItemStack();
        EntityEquipmentSlot modSlot = stackRef.func_77973_b() instanceof ItemArmorBase ? EntityLiving.func_184640_d((ItemStack)stackRef) : EntityEquipmentSlot.MAINHAND;
        Multimap mods = event.getItemStack().func_111283_C(modSlot);
        mods.forEach((attribute, mod) -> {
            if (mod.func_111169_c() != 0) {
                return;
            }
            if (mod.func_111167_a().equals(PROTECTION_UUID) || mod.func_111167_a().equals(ATTACK_UUID) || mod.func_111167_a().equals(TOUGHNESS_UUID)) {
                String tooltipTest = ItemStack.field_111284_a.format(mod.func_111164_d()) + " " + I18n.func_74838_a((String)("attribute.name." + attribute));
                List tooltip = event.getToolTip();
                for (int i = 0; i < tooltip.size(); ++i) {
                    String line = (String)tooltip.get(i);
                    if (!line.endsWith(tooltipTest)) continue;
                    tooltip.set(i, line.replace(TextFormatting.BLUE.toString(), FontColor.encodeColor(this.metal.getStats().getColorHex())));
                }
            }
        });
    }
}

