/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.all;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.all.TartariteEffect;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.NBTUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HaderothEffect
extends BaseMetallurgyEffect {
    private final NBTTagCompound rebornCompound = new NBTTagCompound();

    public HaderothEffect() {
        super(ModMetals.HADEROTH);
        this.rebornCompound.func_74757_a("reborn", true);
        this.rebornCompound.func_74776_a("durability_boost", 25.0f);
        this.rebornCompound.func_74776_a("attack_boost", 2.0f);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ALL;
    }

    @Override
    public int getLevel(EntityLivingBase entity) {
        return super.getLevel(entity);
    }

    @SubscribeEvent
    public void applyToolMetamorphosis(BlockEvent.BreakEvent event) {
        this.applyItemMetamorphosis(event.getPlayer().func_184614_ca(), event.getPlayer());
    }

    @SubscribeEvent
    public void applyWeaponMetamorphosis(AttackEntityEvent event) {
        this.applyItemMetamorphosis(event.getEntityPlayer().func_184614_ca(), event.getEntityPlayer());
    }

    @SubscribeEvent
    public void applyHoeMetamorphosis(UseHoeEvent event) {
        this.applyItemMetamorphosis(event.getCurrent(), event.getEntityPlayer());
    }

    private void applyItemMetamorphosis(ItemStack stack, EntityPlayer destroyingAgent) {
        if (ItemUtils.isMadeOfMetal(this.metal, stack.func_77973_b(), new Class[0]) || TartariteEffect.getParagonMetal(stack) == this.metal) {
            int remainingUses = stack.func_77958_k() - stack.func_77952_i();
            if (remainingUses > 1) {
                return;
            }
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("reborn")) {
                return;
            }
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(this.rebornCompound);
            } else {
                NBTUtils.injectCompound("", stack.func_77978_p(), this.rebornCompound);
            }
            stack.func_77964_b(0);
            destroyingAgent.field_70170_p.func_184133_a(null, destroyingAgent.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.75f, 1.25f);
        }
    }

    @SubscribeEvent
    public void applyWeaponAttackBoost(LivingHurtEvent event) {
        Entity source = event.getSource().func_76364_f();
        if (source instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source;
            if (this.getLevel(attacker) < 10) {
                return;
            }
            NBTTagCompound weaponData = attacker.func_184614_ca().func_77978_p();
            if (weaponData != null && weaponData.func_74767_n("reborn")) {
                event.setAmount(event.getAmount() + weaponData.func_74760_g("attack_boost"));
            }
        }
    }

    @SubscribeEvent
    public void applyToolEfficiencyBoost(PlayerEvent.BreakSpeed event) {
        ItemStack toolStack;
        EntityPlayer player = event.getEntityPlayer();
        if (this.getLevel((EntityLivingBase)player) >= 10 && (toolStack = player.func_184614_ca()).func_77978_p() != null && toolStack.func_77978_p().func_74767_n("reborn")) {
            event.setNewSpeed(event.getOriginalSpeed() * 2.0f);
        }
    }

    @SubscribeEvent
    public void applyArmorMetamorphosis(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (this.getLevel(entity) == 0) {
            return;
        }
        float damage = event.getAmount() / 4.0f;
        if (damage < 1.0f) {
            damage = 1.0f;
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            MetalStats stats;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            ItemStack stack = entity.func_184582_a(slot);
            if (ItemUtils.isMadeOfMetal(this.metal, stack.func_77973_b(), new Class[0])) {
                stats = this.metal.getStats();
            } else {
                if (TartariteEffect.getParagonMetal(stack) != this.metal) continue;
                stats = ModMetals.TARTARITE.getStats();
            }
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("reborn") || !(stack.func_77973_b() instanceof ItemArmor) || !((float)stack.func_77952_i() + damage * 3.0f >= (float)stack.func_77958_k())) continue;
            ItemStack newPiece = stack.func_77946_l();
            int newProtection = stats.getArmorStats().getDamageReduction()[slot.func_188454_b()] + 2;
            float newToughness = stats.getArmorStats().getToughness() + 0.5f;
            AttributeModifier PROTECTION_MODIFIER = new AttributeModifier("Haderoth Armor Protection Buff", (double)newProtection, 0);
            AttributeModifier TOUGHNESS_MODIFIER = new AttributeModifier("Haderoth Armor Toughness Buff", (double)newToughness, 0);
            newPiece.func_185129_a(SharedMonsterAttributes.field_188791_g.func_111108_a(), PROTECTION_MODIFIER, slot);
            newPiece.func_185129_a(SharedMonsterAttributes.field_189429_h.func_111108_a(), TOUGHNESS_MODIFIER, slot);
            if (newPiece.func_77978_p() == null) {
                newPiece.func_77982_d(this.rebornCompound);
            } else {
                NBTUtils.injectCompound("", newPiece.func_77978_p(), this.rebornCompound);
            }
            newPiece.func_77964_b(0);
            entity.func_184201_a(slot, newPiece);
            entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_191263_gW, SoundCategory.PLAYERS, 0.75f, 1.0f);
            entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.5f, 1.25f);
        }
    }
}

