/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.all;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.all.TartariteEffect;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.item.tool.IToolEffect;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AmordrineEffect
extends BaseMetallurgyEffect {
    public AmordrineEffect() {
        super(ModMetals.AMORDRINE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ALL;
    }

    @SubscribeEvent
    public void bindEquipmentToCorpse(PlayerDropsEvent event) {
        if (event.getEntityPlayer().func_130014_f_().func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        Iterator<EntityItem> dropIterator = event.getDrops().iterator();
        AmordrineEffect.removeItemsFromDrops(this.metal, event.getEntityPlayer(), dropIterator);
    }

    protected static void removeItemsFromDrops(Metal metal, @Nullable EntityPlayer player, Iterator<EntityItem> dropIter) {
        while (dropIter.hasNext()) {
            EntityItem dropEntity = dropIter.next();
            ItemStack item = dropEntity.func_92059_d();
            if (!ItemUtils.isMadeOfMetal(metal, item.func_77973_b(), new Class[0]) && TartariteEffect.getParagonMetal(item) != metal || !(item.func_77973_b() instanceof ItemArmorBase) && !(item.func_77973_b() instanceof IToolEffect)) continue;
            if (player != null) {
                player.func_191521_c(item);
            }
            dropIter.remove();
        }
    }

    @SubscribeEvent
    public void copyEquipmentToNewEntity(PlayerEvent.Clone event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntityPlayer().func_130014_f_().func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        if (event.isWasDeath()) {
            event.getOriginal().field_71071_by.field_70462_a.forEach(stack -> {
                if (ItemUtils.isMadeOfMetal(this.metal, stack.func_77973_b(), new Class[0]) || TartariteEffect.getParagonMetal(stack) == this.metal) {
                    event.getEntityPlayer().func_191521_c(stack);
                }
            });
        }
    }
}

