/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect;

import com.google.common.base.CaseFormat;
import it.hurts.metallurgy_reforged.Metallurgy;
import it.hurts.metallurgy_reforged.config.EffectsRosterConfig;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.MetallurgyEffects;
import it.hurts.metallurgy_reforged.effect.all.TartariteEffect;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.item.tool.IToolEffect;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.network.PacketManager;
import it.hurts.metallurgy_reforged.network.client.PacketSpawnOreParticles;
import it.hurts.metallurgy_reforged.proxy.ClientProxy;
import it.hurts.metallurgy_reforged.render.font.FontColor;
import it.hurts.metallurgy_reforged.util.EventUtils;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.ModChecker;
import it.hurts.metallurgy_reforged.util.Utils;
import java.lang.reflect.Field;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BaseMetallurgyEffect {
    public static boolean pneumaticcraftPatchMessageSent = false;
    private final Field configOption;
    public final String name;
    protected Metal metal;
    private final float[] rgbComponents;

    public BaseMetallurgyEffect(Metal metal) {
        Field configOption;
        this.metal = metal;
        this.name = metal != null ? Utils.localizeEscapingCustomSequences("tooltip.metallurgy.effect." + metal + "_" + (Object)((Object)this.getCategory())) : "";
        this.rgbComponents = metal != null ? Utils.getRGBComponents(metal.getStats().getColorHex(), null) : null;
        String camelMetal = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, metal.toString());
        try {
            configOption = EffectsRosterConfig.class.getDeclaredField(camelMetal + "Effect" + Utils.capitalize(this.getCategory().toString()));
        }
        catch (NoSuchFieldException e) {
            configOption = null;
        }
        this.configOption = configOption;
        if (this.isEnabled()) {
            MetallurgyEffects.effects.put((Object)Objects.requireNonNull(metal), (Object)this.getCategory(), (Object)this);
        }
    }

    public boolean isEnabled() {
        if (this.metal != null && this.configOption != null) {
            try {
                return this.configOption.getBoolean(EffectsRosterConfig.class);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Nonnull
    public abstract EnumEffectCategory getCategory();

    public int getLevel(EntityLivingBase entity) {
        if (entity == null || !this.isEnabled()) {
            return 0;
        }
        EnumEffectCategory category = this.getCategory();
        if (ModChecker.isPneumaticCraftLoaded) {
            try {
                Class<?> pneuClass = this.getClass().getClassLoader().loadClass("me.desht.pneumaticcraft.common.util.fakeplayer.DroneFakePlayer");
                if (pneuClass.isInstance(entity)) {
                    if (!pneumaticcraftPatchMessageSent) {
                        Metallurgy.logger.warn("Metallurgy has just bypassed Pneumaticcraft's DroneFakePlayer class to avoid a crash");
                        pneumaticcraftPatchMessageSent = true;
                    }
                    return 0;
                }
            }
            catch (ClassNotFoundException e) {
                Metallurgy.logger.error("Error while bypassing Pneumaticcraft's Broken DroneFakePlayer class");
                e.printStackTrace();
            }
        }
        Item toolItem = entity.func_184614_ca().func_77973_b();
        if (category == EnumEffectCategory.ALL) {
            int level = EventUtils.getArmorPiecesCount(entity, this.metal);
            for (ItemStack armorStack : entity.func_184193_aE()) {
                if (TartariteEffect.getParagonMetal(armorStack) != this.metal) continue;
                level = Math.min(level + 2, 4);
            }
            if (ItemUtils.isMadeOfMetal(this.metal, toolItem, IToolEffect.class) || TartariteEffect.getParagonMetal(entity.func_184614_ca()) == this.metal) {
                level += 10;
            }
            return level;
        }
        if (category == EnumEffectCategory.ARMOR) {
            int originalPieces = EventUtils.getArmorPiecesCount(entity, this.metal);
            for (ItemStack armorStack : entity.func_184193_aE()) {
                if (TartariteEffect.getParagonMetal(armorStack) != this.metal) continue;
                originalPieces = Math.min(originalPieces + 2, 4);
            }
            return originalPieces;
        }
        if ((ItemUtils.isMadeOfMetal(this.metal, toolItem, new Class[0]) || TartariteEffect.getParagonMetal(entity.func_184614_ca()) == this.metal) && toolItem instanceof IToolEffect) {
            IToolEffect tool = (IToolEffect)toolItem;
            if (ArrayUtils.contains((Object[])category.getTools(), (Object)((Object)tool.getToolClass()))) {
                return 10;
            }
        }
        return 0;
    }

    public boolean canBeApplied(EntityLivingBase entity) {
        return this.getLevel(entity) > 0;
    }

    protected ItemStack getArmorRepr(EntityLivingBase entity) {
        if (this.getCategory() == EnumEffectCategory.ARMOR) {
            for (ItemStack stack : entity.func_184193_aE()) {
                if (!ItemUtils.isMadeOfMetal(this.metal, stack.func_77973_b(), new Class[0])) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public Pair<String, String> getTooltip() {
        String format = FontColor.encodeColor(this.metal.getStats().getColorHex());
        String description = Utils.localizeEscapingCustomSequences("tooltip.metallurgy.effect." + this.metal.toString() + "_" + (Object)((Object)this.getCategory()) + ".tooltip");
        return ImmutablePair.of((Object)(format + this.name), (Object)description);
    }

    protected void spawnParticle(Entity entity, float scale, boolean dynamic, int level) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        double x = entity.field_70165_t + (Utils.random.nextDouble() - 0.5) * (double)entity.field_70130_N;
        double y = entity.field_70163_u + Utils.random.nextDouble() * (double)entity.field_70131_O;
        double z = entity.field_70161_v + (Utils.random.nextDouble() - 0.5) * (double)entity.field_70130_N;
        PacketManager.network.sendToAllTracking((IMessage)new PacketSpawnOreParticles(x, y, z, this.metal.getStats().getColorHex(), scale, dynamic, level), entity);
        if (entity instanceof EntityPlayerMP) {
            PacketManager.network.sendTo((IMessage)new PacketSpawnOreParticles(x, y, z, this.metal.getStats().getColorHex(), scale, dynamic, level), (EntityPlayerMP)entity);
        }
    }

    protected void spawnParticle(World world, BlockPos pos, float scale, boolean dynamic, int level, double motionX, double motionY, double motionZ) {
        if (world.field_72995_K) {
            return;
        }
        AxisAlignedBB box = world.func_180495_p(pos).func_185900_c((IBlockAccess)world, pos);
        double width = box.field_72336_d - box.field_72340_a;
        double height = box.field_72337_e - box.field_72338_b;
        double depth = box.field_72334_f - box.field_72339_c;
        double border = 0.15;
        double x = (double)pos.func_177958_n() + box.field_72340_a - border + (width + border * 2.0) * Utils.random.nextDouble();
        double y = (double)pos.func_177956_o() + box.field_72338_b - border + (height + border * 2.0) * Utils.random.nextDouble();
        double z = (double)pos.func_177952_p() + box.field_72339_c - border + (depth + border * 2.0) * Utils.random.nextDouble();
        this.spawnParticle(world, x, y, z, motionX, motionY, motionZ, scale, dynamic, level);
    }

    protected void spawnParticle(World world, double x, double y, double z, double motionX, double motionY, double motionZ, float scale, boolean dynamic, int level) {
        if (world.field_72995_K) {
            return;
        }
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, 64.0);
        PacketManager.network.sendToAllTracking((IMessage)new PacketSpawnOreParticles(x, y, z, motionX, motionY, motionZ, this.metal.getStats().getColorHex(), scale, dynamic, level), targetPoint);
    }

    protected void spawnParticle(World world, double x, double y, double z, float scale, boolean dynamic, int level) {
        if (world.field_72995_K) {
            ClientProxy.clientSpawnParticle(world, x, y, z, this.rgbComponents[0], this.rgbComponents[1], this.rgbComponents[2], scale, dynamic, level);
        } else {
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, 64.0);
            PacketManager.network.sendToAllTracking((IMessage)new PacketSpawnOreParticles(x, y, z, this.metal.getStats().getColorHex(), scale, dynamic, level), targetPoint);
        }
    }

    public void rightClickHandler(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
    }

    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull Entity entityIn, int itemSlot, boolean isSelected) {
    }

    protected void setupModelOverrides(IItemPropertyGetter condition) {
        for (EnumTools tool : this.getCategory().getTools()) {
            this.metal.getTool(tool).func_185043_a(new ResourceLocation("active"), condition);
        }
    }

    public Metal getMetal() {
        return this.metal;
    }

    public final String getName() {
        return this.name;
    }
}

