/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.config;

import it.hurts.metallurgy_reforged.Metallurgy;
import java.lang.reflect.Field;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Config.LangKey(value="config.metallurgy.category.worldgen")
@Config(modid="metallurgy", name="metallurgy_reforged/worldgen", category="ore_generation")
public class WorldGenerationConfig {
    private static final int HEIGHT_LIMIT = 255;
    private static final int NETHER_HEIGHT_LIMIT = 127;
    public static SubCategoryRarity rarity = new SubCategoryRarity();
    public static CategoryAdamantine adamantine = new CategoryAdamantine();
    public static CategoryAstralSilver astralSilver = new CategoryAstralSilver();
    public static CategoryAtlarus atlarus = new CategoryAtlarus();
    public static CategoryCarmot carmot = new CategoryCarmot();
    public static CategoryCopper copper = new CategoryCopper();
    public static CategoryDeepIron deepIron = new CategoryDeepIron();
    public static CategoryInfuscolium infuscolium = new CategoryInfuscolium();
    public static CategoryManganese manganese = new CategoryManganese();
    public static CategoryMithril mithril = new CategoryMithril();
    public static CategoryOureclase oureclase = new CategoryOureclase();
    public static CategoryOrichalcum orichalcum = new CategoryOrichalcum();
    public static CategoryOsmium osmium = new CategoryOsmium();
    public static CategoryPhosphorite phosphorite = new CategoryPhosphorite();
    public static CategoryPlatinum platinum = new CategoryPlatinum();
    public static CategoryPotash potash = new CategoryPotash();
    public static CategoryPrometheum prometheum = new CategoryPrometheum();
    public static CategoryRubracium rubracium = new CategoryRubracium();
    public static CategorySilver silver = new CategorySilver();
    public static CategorySulfur sulfur = new CategorySulfur();
    public static CategoryTin tin = new CategoryTin();
    public static CategoryZinc zinc = new CategoryZinc();
    public static CategoryAlduorite alduorite = new CategoryAlduorite();
    public static CategoryCeruclase cerucalse = new CategoryCeruclase();
    public static CategoryIgnatius ignatius = new CategoryIgnatius();
    public static CategoryKalendrite kalendrite = new CategoryKalendrite();
    public static CategoryLemurite lemurite = new CategoryLemurite();
    public static CategoryLutetium lutetium = new CategoryLutetium();
    public static CategoryMidasium midasium = new CategoryMidasium();
    public static CategorySanguinite sanguinite = new CategorySanguinite();
    public static CategoryShadowIron shadowIron = new CategoryShadowIron();
    public static CategoryVulcanite vulcanite = new CategoryVulcanite();
    public static CategoryVyroxeres vyroxeres = new CategoryVyroxeres();
    public static CategoryEximite eximite = new CategoryEximite();
    public static CategoryMeutoite meutoite = new CategoryMeutoite();
    @Config.Name(value="The spawnrate of tar lakes in the overworld")
    @Config.Comment(value={"Sets to 0 to disable tar lakes world generation"})
    @Config.RangeInt(min=0, max=500)
    public static int tarLakePercentage = 20;
    @Config.Name(value="Tar Lakes Worldgen Dimension Whitelist")
    @Config.Comment(value={"Add the ID of the dimensions you want tar lakes to spawn in"})
    public static Integer[] tarLakeDimensionWhiteList = new Integer[]{0};
    @Config.Name(value="Retrogen")
    @Config.Comment(value={"Enable/Disable Retrogen"})
    public static boolean retrogen = true;
    @Config.Name(value="Verbose Retrogen")
    @Config.Comment(value={"Enable/Disable verbose logging for retrogen"})
    public static boolean verbose_retrogen = false;

    @Deprecated
    public static void proofCheckBiomes() {
        Field[] categories;
        for (Field category : categories = WorldGenerationConfig.class.getFields()) {
            try {
                String[] biomes;
                Object catObj = category.get(null);
                for (String biome : biomes = (String[])catObj.getClass().getDeclaredField("biomes").get(catObj)) {
                    if (ForgeRegistries.BIOMES.containsKey(new ResourceLocation(biome))) continue;
                    Metallurgy.logger.warn("The biome '" + biome + "' declared in the world generation config doesn't exist!");
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    public static class SubCategoryRarity {
        @Config.Name(value="Common Ore Rarity")
        @Config.Comment(value={"Set the value of common Rarity [ The smaller the value, the rarer it is ] (Don't change if you aren't a dev)"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=1)
        public int commonRarity = 10;
        @Config.Name(value="Uncommon Ore Rarity")
        @Config.Comment(value={"Set the value of uncommon Rarity [ The smaller the value, the rarer it is ] (Don't change if you aren't a dev)"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=1)
        public int uncommonRarity = 7;
        @Config.Name(value="Rare Ore Rarity")
        @Config.Comment(value={"Set the value of rare Rarity [ The smaller the value, the rarer it is ] (Don't change if you aren't a dev)"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=1)
        public int rareRarity = 5;
        @Config.Name(value="Very Rare Ore Rarity")
        @Config.Comment(value={"Set the value of very rare Rarity [ The smaller the value, the rarer it is ] (Don't change if you aren't a dev)"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=1)
        public int veryRareRarity = 3;
        @Config.Name(value="Ultra Rare Ore Rarity")
        @Config.Comment(value={"Set the value of ultra rare Rarity [ The smaller the value, the rarer it is ] (Don't change if you aren't a dev)"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=1)
        public int ultraRareRarity = 1;
    }

    public static class CategoryCopper {
        @Config.Comment(value={"Copper minimum Y level"})
        @Config.RangeInt(min=2, max=255)
        public int minY = 35;
        @Config.Comment(value={"Copper maximum Y level"})
        @Config.RangeInt(min=2, max=255)
        public int maxY = 120;
        @Config.Comment(value={"Copper indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 8;
        @Config.Comment(value={"Copper biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryDeepIron {
        @Config.Comment(value={"Deep Iron minimum Y level"})
        @Config.RangeInt(min=2, max=255)
        public int minY = 10;
        @Config.Comment(value={"Deep Iron maximum Y level"})
        @Config.RangeInt(min=2, max=255)
        public int maxY = 30;
        @Config.Comment(value={"Deep Iron indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 5;
        @Config.Comment(value={"Deep Iron biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[]{"minecraft:ocean", "minecraft:beaches", "minecraft:river", "minecraft:frozen_river", "minecraft:frozen_ocean", "minecraft:stone_beach", "minecraft:cold_beach"};
    }

    public static class CategoryTin {
        @Config.Comment(value={"Tin minimum Y level"})
        @Config.RangeInt(min=2, max=255)
        public int minY = 28;
        @Config.Comment(value={"Tin maximum Y level"})
        @Config.RangeInt(min=2, max=255)
        public int maxY = 50;
        @Config.Comment(value={"Tin indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 8;
        @Config.Comment(value={"Tin biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryPrometheum {
        @Config.Comment(value={"Prometheum minimum Y level"})
        @Config.RangeInt(min=2, max=255)
        public int minY = 0;
        @Config.Comment(value={"Prometheum maximum Y level"})
        @Config.RangeInt(min=2, max=255)
        public int maxY = 64;
        @Config.Comment(value={"Prometheum indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 6;
        @Config.Comment(value={"Prometheum biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[]{"minecraft:jungle", "minecraft:jungle_hills", "minecraft:jungle_edge"};
    }

    public static class CategoryManganese {
        @Config.Comment(value={"Manganese minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 16;
        @Config.Comment(value={"Manganese maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 128;
        @Config.Comment(value={"Manganese indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 8;
        @Config.Comment(value={"Manganese biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryOureclase {
        @Config.Comment(value={"Ourseclase minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 0;
        @Config.Comment(value={"Ourseclase maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 96;
        @Config.Comment(value={"Ourseclase indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 6;
        @Config.Comment(value={"Ourseclase biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryInfuscolium {
        @Config.Comment(value={"Infuscolium minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 18;
        @Config.Comment(value={"Infuscolium maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 72;
        @Config.Comment(value={"Infuscolium indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 5;
        @Config.Comment(value={"Infuscolium biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryRubracium {
        @Config.Comment(value={"Rubracium minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 0;
        @Config.Comment(value={"Rubracium maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 30;
        @Config.Comment(value={"Rubracium indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 6;
        @Config.Comment(value={"Rubracium biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryAdamantine {
        @Config.Comment(value={"Adamantine minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 0;
        @Config.Comment(value={"Adamantine maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 30;
        @Config.Comment(value={"Adamantine indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 3;
        @Config.Comment(value={"Adamantine biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryAtlarus {
        @Config.Comment(value={"Atlarus minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 22;
        @Config.Comment(value={"Atlarus maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 48;
        @Config.Comment(value={"Atlarus indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 5;
        @Config.Comment(value={"Atlarus biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryCarmot {
        @Config.Comment(value={"Carmot minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 24;
        @Config.Comment(value={"Carmot maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 52;
        @Config.Comment(value={"Carmot indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 4;
        @Config.Comment(value={"Carmot biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryMithril {
        @Config.Comment(value={"Mithril minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 32;
        @Config.Comment(value={"Mithril maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 128;
        @Config.Comment(value={"Mithril indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 5;
        @Config.Comment(value={"Mithril biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryZinc {
        @Config.Comment(value={"Zinc minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 0;
        @Config.Comment(value={"Zinc maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 128;
        @Config.Comment(value={"Zinc indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 8;
        @Config.Comment(value={"Zinc biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryOrichalcum {
        @Config.Comment(value={"Orichalcum minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 0;
        @Config.Comment(value={"Orichalcum maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 128;
        @Config.Comment(value={"Orichalcum indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 6;
        @Config.Comment(value={"Orichalcum biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryAstralSilver {
        @Config.Comment(value={"Astral Silver minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 40;
        @Config.Comment(value={"Astral Silver maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 140;
        @Config.Comment(value={"Astral Silver indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 6;
        @Config.Comment(value={"Astral Silver biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategorySilver {
        @Config.Comment(value={"Silver minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 0;
        @Config.Comment(value={"Silver maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 128;
        @Config.Comment(value={"Silver indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 8;
        @Config.Comment(value={"Silver biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryPlatinum {
        @Config.Comment(value={"Platinum minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 0;
        @Config.Comment(value={"Platinum maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 80;
        @Config.Comment(value={"Platinum indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 4;
        @Config.Comment(value={"Platinum biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryOsmium {
        @Config.Comment(value={"Osmium minimum Y level"})
        @Config.RangeInt(min=2, max=255)
        public int minY = 3;
        @Config.Comment(value={"Osmium maximum Y level"})
        @Config.RangeInt(min=2, max=255)
        public int maxY = 10;
        @Config.Comment(value={"Osmium indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 6;
        @Config.Comment(value={"Osmium biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategorySulfur {
        @Config.Comment(value={"Sulfur minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 0;
        @Config.Comment(value={"Sulfur maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 15;
        @Config.Comment(value={"Sulfur indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 6;
        @Config.Comment(value={"Sulfur biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryPhosphorite {
        @Config.Comment(value={"Phosphorite minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 0;
        @Config.Comment(value={"Phosphorite maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 100;
        @Config.Comment(value={"Phosphorite indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 5;
        @Config.Comment(value={"Phosphorite biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryPotash {
        @Config.Comment(value={"Potash minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 32;
        @Config.Comment(value={"Potash maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 72;
        @Config.Comment(value={"Potash indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 7;
        @Config.Comment(value={"Potash biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryAlduorite {
        @Config.Comment(value={"Alduorite minimum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int minY = 70;
        @Config.Comment(value={"Alduorite maximum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int maxY = 127;
        @Config.Comment(value={"Alduorite indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 4;
        @Config.Comment(value={"Alduorite biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryCeruclase {
        @Config.Comment(value={"Ceruclase minimum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int minY = 0;
        @Config.Comment(value={"Ceruclase maximum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int maxY = 127;
        @Config.Comment(value={"Ceruclase indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 5;
        @Config.Comment(value={"Ceruclase biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryIgnatius {
        @Config.Comment(value={"Ignatius minimum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int minY = 32;
        @Config.Comment(value={"Ignatius maximum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int maxY = 96;
        @Config.Comment(value={"Ignatius indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 8;
        @Config.Comment(value={"Ignatius biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryKalendrite {
        @Config.Comment(value={"Kalendrite minimum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int minY = 27;
        @Config.Comment(value={"Kalendrite maximum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int maxY = 120;
        @Config.Comment(value={"Kalendrite indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 5;
        @Config.Comment(value={"Kalendrite biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryLemurite {
        @Config.Comment(value={"Lemurite minimum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int minY = 0;
        @Config.Comment(value={"Lemurite maximum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int maxY = 50;
        @Config.Comment(value={"Lemurite indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 6;
        @Config.Comment(value={"Lemurite biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryLutetium {
        @Config.Comment(value={"Lutetium minimum Y level"})
        @Config.RangeInt(min=2, max=127)
        public int minY = 20;
        @Config.Comment(value={"Lutetium maximum Y level"})
        @Config.RangeInt(min=2, max=127)
        public int maxY = 50;
        @Config.Comment(value={"Lutetium indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 4;
        @Config.Comment(value={"Lutetium biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryMidasium {
        @Config.Comment(value={"Midasium minimum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int minY = 32;
        @Config.Comment(value={"Midasium maximum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int maxY = 127;
        @Config.Comment(value={"Midasium indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 6;
        @Config.Comment(value={"Midasium biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryShadowIron {
        @Config.Comment(value={"Shadow Iron minimum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int minY = 96;
        @Config.Comment(value={"Shadow Iron maximum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int maxY = 32;
        @Config.Comment(value={"Shadow Iron indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 7;
        @Config.Comment(value={"Shadow Iron biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategorySanguinite {
        @Config.Comment(value={"Sanguinite minimum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int minY = 0;
        @Config.Comment(value={"Sanguinite maximum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int maxY = 128;
        @Config.Comment(value={"Sanguinite indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 4;
        @Config.Comment(value={"Sanguinite biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryVulcanite {
        @Config.Comment(value={"Vulcanite minimum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int minY = 27;
        @Config.Comment(value={"Vulcanite maximum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int maxY = 39;
        @Config.Comment(value={"Vulcanite indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 5;
        @Config.Comment(value={"Vulcanite biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryVyroxeres {
        @Config.Comment(value={"Vyroxeres minimum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int minY = 0;
        @Config.Comment(value={"Vyroxeres maximum Y level"})
        @Config.RangeInt(min=0, max=127)
        public int maxY = 120;
        @Config.Comment(value={"Vyroxeres indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 5;
        @Config.Comment(value={"Vyroxeres biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryEximite {
        @Config.Comment(value={"Eximite minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 0;
        @Config.Comment(value={"Eximite maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 128;
        @Config.Comment(value={"Eximite indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 7;
        @Config.Comment(value={"Eximite biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }

    public static class CategoryMeutoite {
        @Config.Comment(value={"Meutoite minimum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int minY = 0;
        @Config.Comment(value={"Meutoite maximum Y level"})
        @Config.RangeInt(min=0, max=255)
        public int maxY = 128;
        @Config.Comment(value={"Meutoite indicative vein size (Set to 0 to disable this ore)"})
        @Config.RangeInt(min=0)
        public int veinSize = 7;
        @Config.Comment(value={"Meutoite biome spawn"})
        @Config.RequiresWorldRestart
        public String[] biomes = new String[0];
    }
}

