/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config.LangKey(value="config.metallurgy.category.general")
@Config(modid="metallurgy", name="metallurgy_reforged/general")
public class GeneralConfig {
    @Config.Name(value="Enable On World Join Message")
    @Config.Comment(value={"When set to true it shows the warning message when joining the world"})
    @Config.RequiresMcRestart
    public static boolean warning = true;
    @Config.Name(value="Road Speed Multiplier")
    @Config.Comment(value={"Set the road speed multiplier"})
    @Config.RangeDouble(min=1.0)
    public static double roadSpeed = 1.5;
    @Config.Name(value="Disable tinker integration")
    @Config.Comment(value={"Set to true to disable Tinkers' Construct Integration"})
    public static boolean tinkerIntegration = false;
    @Config.Name(value="Tinker Materials Blacklist")
    @Config.Comment(value={"Add a material in this array to blacklist it during game boot - material name format is \"snake_case\" (e.g. 'osmium' or 'damascus_steel')"})
    @Config.RequiresMcRestart
    public static String[] tinkerMaterialsBlacklist = new String[0];
    @Config.Name(value="Disable ConArm Integration")
    @Config.Comment(value={"Set to true to disable Construct's Armory Integration"})
    public static boolean armoryIntegration = false;
    @Config.Name(value="Disable IF Integration")
    @Config.Comment(value={"Set to true to disable Industrial Foregoing Integration"})
    public static boolean inForegoingIntegration = false;
    @Config.Name(value="Disable Automatic EMC values")
    @Config.Comment(value={"Set to true to disable default EMC values"})
    public static boolean projectEIntegration = false;
    @Config.Name(value="Enable Duplication Trait")
    @Config.Comment(value={"When set to true the duplication trait from tinker integration is enabled"})
    public static boolean enableDuplicationTrait = true;
    @Config.Name(value="Should Tool be repairable in Anvil")
    @Config.Comment(value={"Set this to true to be able to repair tools in Vanilla Anvil"})
    public static boolean enableAnvilToolRepair = true;
    @Config.Name(value="Should Armor be repairable in Anvil")
    @Config.Comment(value={"Set this to true to enable the possibility to repair armors in Vanilla Anvil"})
    public static boolean enableAnvilArmorRepair = true;
    @Config.Name(value="Enable Ore Particles")
    @Config.Comment(value={"Set this to true to enable ore particles (Particles that are bigger depending on the harvest tier of the ore) [default: false]"})
    public static boolean enableOreParticles = true;
    @Config.Name(value="Should High Tier Ore emit light")
    @Config.Comment(value={"Set this to true to make ore blocks that have a harvest level higher than 5 to emit light [default: false]"})
    @Config.RequiresWorldRestart
    public static boolean enableOreLight = true;
    @Config.Name(value="OreDict Crusher Recipes")
    @Config.Comment(value={"When set to true the mod will load new recipes from the OreDictionary (this could cause some incompatibility issues when removing recipes with CraftTweaker disable this if you see that some recipes are not being removed)"})
    @Config.RequiresMcRestart
    public static boolean enableOreDictCrusherRecipes = true;
    @Config.Name(value="Enable Custom Materials Stats Configuration file")
    @Config.Comment(value={"Loads the `material.json` file in the config folder that allows players to edit any material stat in the mod and to disable specific metals"})
    @Config.RequiresMcRestart
    public static boolean enableCustomMaterialStatsConfig = false;
    @Config.Name(value="Enable EnderIO alloying recipes xml file")
    @Config.Comment(value={"Loads the `metallurgy_enderio_alloys.xml` file in the config folder that allows players to edit alloy recipes that you can make in the Alloy Smelter from EnderIO"})
    @Config.RequiresMcRestart
    public static boolean enableEnderIOAlloyConfig = false;
    @Deprecated
    @Config.Ignore
    @Config.Name(value="Enable Metallurgy Tweaks Scripts replacing")
    @Config.Comment(value={"Loads the scripts from the jar and copies them into CraftTweakers scripts folder, this option should be enabled to receive updates for Metallurgy Tweaks, but may be disabled if you want to tweak Metallurgy Tweaks config file without it getting replaced"})
    public static boolean enableMetallurgyTweaksUpdateReplace = true;
    @Config.Name(value="Mob that can spawn equipped")
    @Config.Comment(value={"A list of mob ids that can spawn with metallurgy armor and/or tools"})
    public static String[] mobsThatCanHaveEquipment = new String[]{"minecraft:zombie", "minecraft:skeleton", "minecraft:wither_skeleton", "minecraft:stray", "minecraft:husk"};
    @Config.Name(value="Metal equipment spawn blacklist")
    @Config.Comment(value={"A list of metals which cannot be equipped by mobs. \n Metal names must be written in snake case."})
    public static String[] metalsThatCannotBeEquipped = new String[0];

    public static class ChangeListener {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals("metallurgy")) {
                ConfigManager.sync((String)"metallurgy", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

