/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.config;

import net.minecraftforge.common.config.Config;

public class GadgetsConfig {

    @Config.LangKey(value="config.metallurgy.category.ignatius_fuel")
    @Config(modid="metallurgy", name="metallurgy_reforged/gadgets", category="ignatius_fuel")
    public static class IgnatiusFuel {
        @Config.Name(value="Infused Ignatius Fuel Value")
        @Config.Comment(value={"How many items should 1 infused ignatius item process in a vanilla furnace (this value is automatically tripled when the fuel is used in metallurgy machines) [default: 8]"})
        @Config.RangeInt(min=1, max=64)
        @Config.SlidingOption
        @Config.RequiresMcRestart
        public static int ignatiusFuelValue = 24;
    }

    @Config.LangKey(value="config.metallurgy.category.thermite_dust")
    @Config(modid="metallurgy", name="metallurgy_reforged/gadgets", category="thermite_dust")
    public static class ThermiteDust {
        @Config.Name(value="Thermite Fuel Temperature")
        @Config.Comment(value={"The Temperature required to melt thermite in a Tinkers' Construct Smeltery"})
        public static int temperature = 400;
        @Config.Name(value="Thermite Fuel Value")
        @Config.Comment(value={"How many items should 1 thermite item cook in a vanilla furnace (this value is automatically doubled when thermite is used in metallurgy machines) [default: 8]"})
        @Config.RangeInt(min=1, max=64)
        @Config.SlidingOption
        @Config.RequiresMcRestart
        public static int thermiteFuelValue = 8;
    }

    @Config.RequiresMcRestart
    @Config.LangKey(value="config.metallurgy.category.brass_knuckles")
    @Config(modid="metallurgy", name="metallurgy_reforged/gadgets", category="brass_knuckles")
    public static class BrassKnuckles {
        @Config.Name(value="Brass Knuckles Attack Damage")
        @Config.Comment(value={"Affects the damage for each hit when attacking with brass knuckles | value is summed to default items' damage value"})
        public static double attackDamage = 1.0;
        @Config.Name(value="Brass Knuckles Attack Speed")
        @Config.Comment(value={"Affects the amount of hits of brass knucles in a certain time lapse | value is summed to default items' damage value"})
        public static double attackSpeed = 16.0;
    }

    @Config.LangKey(value="config.metallurgy.category.phosphorus_lamp")
    @Config(modid="metallurgy", name="metallurgy_reforged/gadgets", category="phosphorus_lamp")
    public static class PhosphorusLamp {
        @Config.Name(value="Lantern entity collision")
        @Config.Comment(value={"Set this to false to disable entity collisions with lantern"})
        public static boolean enableLanternCollision = true;
        @Config.Name(value="Phosphorus Lantern Light Level")
        @Config.Comment(value={"Sets how bright the lantern should be"})
        public static int lanternLightLevel = 8;
    }

    @Config.LangKey(value="config.metallurgy.category.rubracium_gauntlet")
    @Config(modid="metallurgy", name="metallurgy_reforged/gadgets", category="gauntlet")
    public static class Gauntlet {
        @Config.Name(value="Gauntlet Durability")
        @Config.Comment(value={"Sets the Maximum Durability for the Rubracium Gauntlet"})
        @Config.RequiresMcRestart
        public static int gauntletMaxDamage = 750;
        @Config.Name(value="Attack Modifier")
        @Config.Comment(value={"Sets the gauntlet attack damage"})
        public static double gauntletAttackDamage = 3.0;
        @Config.Name(value="Attack Speed Modifier")
        @Config.Comment(value={"We suggest to set the value to 16 or else the process bar will be rendered"})
        @Config.RangeDouble(min=-3.0, max=16.0)
        public static double gauntletAttackSpeed = 16.0;
        @Config.Name(value="Gauntlet Hunger Modifier")
        @Config.Comment(value={"Sets the gauntlet hunger modifier [ 1 = 0.5 ]"})
        @Config.RangeInt(min=0)
        public static int gauntletHungerModifier = 1;
        @Config.Name(value="Gauntlet Block Damage")
        @Config.Comment(value={"Sets the damage dealt to the target by being hit on the block"})
        @Config.RangeDouble(min=0.0)
        public static double gauntletBlockDamageModifier = 0.5;
        @Config.Name(value="Gauntlet disable block griefing")
        @Config.Comment(value={"Set to true for disable block griefing"})
        public static boolean disableBlockGriefing = false;
    }
}

