/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.config;

import com.google.common.io.Files;
import it.hurts.metallurgy_reforged.Metallurgy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;

public class ConfigPack {
    private final Path metallurgyConfigDir;
    private boolean justCreated = false;
    private String configPackVersion;

    public ConfigPack(File configDir) {
        this.metallurgyConfigDir = configDir.toPath().resolve("metallurgy_reforged");
        File configPackVer = configDir.toPath().resolve("metallurgy_reforged/config_pack_version").toFile();
        try {
            Files.createParentDirs((File)configPackVer);
            if (configPackVer.createNewFile()) {
                this.updateConfigPackVersion(configPackVer);
                this.justCreated = true;
            } else {
                this.configPackVersion = Files.readFirstLine((File)configPackVer, (Charset)Charset.defaultCharset());
            }
        }
        catch (IOException e) {
            Metallurgy.logger.error("Critical error while doing I/O Operations on config_pack_version");
            e.printStackTrace();
        }
    }

    private void updateConfigPackVersion(File configVersionFile) throws IOException {
        String[] versionNums = "1.3.6".split("\\.");
        this.configPackVersion = versionNums[0] + "." + versionNums[1];
        Files.write((CharSequence)(versionNums[0] + "." + versionNums[1]), (File)configVersionFile, (Charset)Charset.defaultCharset());
    }

    public boolean isNewUpdate() {
        return this.justCreated || !"1.3.6".startsWith(this.configPackVersion);
    }

    public void backupAndResetPack() {
        String backupName = "backup_" + (this.justCreated ? "pre-1.3" : this.configPackVersion);
        File backupDir = this.metallurgyConfigDir.resolve(backupName).toFile();
        try {
            if (!this.backup(backupDir)) {
                return;
            }
        }
        catch (IOException e) {
            Metallurgy.logger.error("Critical I/O error while backing up old Config Pack");
            e.printStackTrace();
        }
        try {
            this.resetConfig();
        }
        catch (IOException e) {
            Metallurgy.logger.error("Critical I/O error while RESETTING Metallurgy 4: Reforged Config Pack");
            e.printStackTrace();
        }
    }

    private boolean backup(File backupDir) throws IOException {
        if (backupDir.mkdir()) {
            File[] configFiles = this.metallurgyConfigDir.toFile().listFiles();
            assert (configFiles != null);
            for (File configFile : configFiles) {
                if (configFile.getName().startsWith("backup_") || configFile.getName().equals("config_pack_version")) continue;
                File backupFile = backupDir.toPath().resolve(configFile.getName()).toFile();
                Files.copy((File)configFile, (File)backupFile);
            }
            return true;
        }
        return false;
    }

    private void resetConfig() throws IOException {
        File[] configFiles = this.metallurgyConfigDir.toFile().listFiles();
        assert (configFiles != null);
        for (File configFile : configFiles) {
            if (configFile.getName().startsWith("backup_") || configFile.getName().equals("config_pack_version")) continue;
            configFile.delete();
        }
        this.updateConfigPackVersion(this.metallurgyConfigDir.resolve("config_pack_version").toFile());
    }
}

