/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.capabilities.effect;

import it.hurts.metallurgy_reforged.network.PacketManager;
import it.hurts.metallurgy_reforged.network.client.PacketSyncEffectBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ProgressiveDataBundle {
    public final int stepTickDelay;
    protected final int maxSteps;
    protected String prefixKey;
    protected int currentStep = 0;
    protected boolean paused = false;
    protected long timestamp = -1L;
    protected ItemStack effectStack = ItemStack.field_190927_a;

    public ProgressiveDataBundle(String prefixKey, int maxSteps, int stepTickDelay) {
        this.prefixKey = prefixKey;
        this.maxSteps = maxSteps;
        this.stepTickDelay = stepTickDelay;
    }

    private void sync(@Nullable EntityPlayer player) {
        if (player != null && !player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            PacketManager.network.sendTo((IMessage)new PacketSyncEffectBundle(this.prefixKey, this), (EntityPlayerMP)player);
        }
    }

    public String getPrefixKey() {
        return this.prefixKey;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public long getPrevStepTime() {
        return this.timestamp;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public ItemStack getEffectStack() {
        return this.effectStack;
    }

    public void updateTimeStamp(@Nonnull EntityPlayer player) {
        this.timestamp = player.field_70170_p.func_82737_E();
    }

    public void setCurrentStep(int currentStep, @Nullable EntityPlayerMP player) {
        this.currentStep = currentStep;
        this.sync((EntityPlayer)player);
    }

    public void setEffectStack(ItemStack effectStack, @Nullable EntityPlayer player) {
        this.effectStack = effectStack;
        this.sync(player);
    }

    public void setPaused(boolean paused, @Nullable EntityPlayer player) {
        this.paused = paused;
        this.sync(player);
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public boolean isEffectInProgress() {
        return this.currentStep > 0 && !this.paused;
    }

    public void incrementStep(@Nullable EntityPlayer player) {
        if (player != null && this.currentStep == 0) {
            this.updateTimeStamp(player);
        }
        if (this.currentStep < this.maxSteps) {
            ++this.currentStep;
            this.sync(player);
        } else {
            this.resetProgress(player);
        }
    }

    public void resetProgress(EntityPlayer player) {
        this.timestamp = -1L;
        this.currentStep = 0;
        this.sync(player);
    }

    public byte getType() {
        return 0;
    }

    @OverridingMethodsMustInvokeSuper
    public void toNBT(NBTTagCompound compound) {
        compound.func_74768_a(this.prefixKey + "_current_step", this.currentStep);
        compound.func_74772_a(this.prefixKey + "_timestamp", this.timestamp);
        compound.func_74757_a(this.prefixKey + "_paused", this.paused);
    }

    @OverridingMethodsMustInvokeSuper
    public void fromNBT(NBTTagCompound compound) {
        this.currentStep = compound.func_74762_e(this.prefixKey + "_current_step");
        this.timestamp = compound.func_74763_f(this.prefixKey + "_timestamp");
        this.paused = compound.func_74767_n(this.prefixKey + "_paused");
    }
}

