/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.capabilities.effect;

import it.hurts.metallurgy_reforged.capabilities.effect.ProgressiveDataBundle;
import it.hurts.metallurgy_reforged.util.NBTUtils;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;

public class ExtraFilledDataBundle
extends ProgressiveDataBundle {
    private NBTTagCompound extra = new NBTTagCompound();
    private final Predicate<ExtraFilledDataBundle> isInProgress;

    public ExtraFilledDataBundle(String key, int maxSteps, int stepDelay, Predicate<ExtraFilledDataBundle> isInProgress) {
        super(key, maxSteps, stepDelay);
        this.isInProgress = isInProgress;
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        super.toNBT(compound);
        NBTUtils.injectCompound(this.prefixKey + "_extra_", compound, this.extra);
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        super.fromNBT(compound);
        this.extra = NBTUtils.ejectCompound(this.prefixKey + "_extra_", compound);
    }

    @Override
    public boolean isEffectInProgress() {
        return this.isInProgress.test(this);
    }

    public NBTTagCompound getExtras() {
        return this.extra;
    }

    public void setExtras(NBTTagCompound compound) {
        this.extra = compound;
    }

    public String getExtraString(String key) {
        return this.extra.func_74779_i(key);
    }

    public int getExtraInt(String key) {
        return this.extra.func_74762_e(key);
    }

    public boolean getExtraBool(String key) {
        return this.extra.func_74767_n(key);
    }

    public float getExtraFloat(String key) {
        return this.extra.func_74760_g(key);
    }

    public double getExtraDouble(String key) {
        return this.extra.func_74760_g(key);
    }

    public void setExtra(String key, String value) {
        this.extra.func_74778_a(key, value);
    }

    public void setExtra(String key, int value) {
        this.extra.func_74768_a(key, value);
    }

    public void setExtra(String key, float value) {
        this.extra.func_74776_a(key, value);
    }

    public void setExtra(String key, double value) {
        this.extra.func_74780_a(key, value);
    }

    public void setExtra(String key, boolean value) {
        this.extra.func_74757_a(key, value);
    }

    public void clearExtras() {
        this.extra = new NBTTagCompound();
    }

    @Override
    public byte getType() {
        return 2;
    }
}

