/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.block.machines;

import com.google.common.collect.Lists;
import it.hurts.metallurgy_reforged.block.machines.BlockTileEntity;
import it.hurts.metallurgy_reforged.recipe.SublimationRecipes;
import it.hurts.metallurgy_reforged.tileentity.TileEntityChamber;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockChamber
extends BlockTileEntity<TileEntityChamber> {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"lit");
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockChamber(String name) {
        super(Material.field_151573_f, name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Class<TileEntityChamber> getTileEntityClass() {
        return TileEntityChamber.class;
    }

    @Override
    public TileEntityChamber createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityChamber();
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            return 8;
        }
        return 0;
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityChamber) {
            TileEntityChamber chamber = (TileEntityChamber)te;
            SublimationRecipes recipes = SublimationRecipes.getInstance();
            int recipeAmount = recipes.getSublimationBlockAmount(stack);
            int currentMetalAmount = chamber.func_70301_a(0).func_190916_E();
            ItemStack fuelStack = chamber.func_70301_a(1);
            int currentFuelAmount = fuelStack.func_190916_E();
            if (facing == EnumFacing.UP) {
                if (recipeAmount > 0 && currentMetalAmount < recipeAmount) {
                    int i = recipeAmount - currentMetalAmount;
                    ItemStack copyStack = stack.func_77979_a(i);
                    copyStack.func_190920_e(currentMetalAmount + copyStack.func_190916_E());
                    chamber.func_70299_a(0, copyStack);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            } else if (facing != EnumFacing.DOWN && (fuelStack.func_190926_b() || stack.func_185136_b(fuelStack)) && chamber.func_94041_b(1, stack)) {
                int i = fuelStack.func_77976_d() - currentFuelAmount;
                ItemStack copyStack = stack.func_77979_a(i);
                copyStack.func_190920_e(currentFuelAmount + copyStack.func_190916_E());
                chamber.func_70299_a(1, copyStack);
                return true;
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @ParametersAreNonnullByDefault
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        if (stack.func_77942_o() && (te = worldIn.func_175625_s(pos)) instanceof TileEntityChamber) {
            TileEntityChamber chamber = (TileEntityChamber)te;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null && tag.func_74764_b("chamberTags")) {
                chamber.readChamberFromNBT(tag.func_74775_l("chamberTags"));
            }
            if (chamber.potionEffect != null) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityChamber) {
            ItemStack itemStack = new ItemStack((Block)this);
            TileEntityChamber chamber = (TileEntityChamber)te;
            if (!chamber.func_191420_l() || chamber.potionEffect != null) {
                NBTTagCompound tag = new NBTTagCompound();
                NBTTagCompound chamberTags = new NBTTagCompound();
                chamber.writeChamberToNBT(chamberTags);
                tag.func_74782_a("chamberTags", (NBTBase)chamberTags);
                itemStack.func_77982_d(tag);
            }
            BlockChamber.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
            world.func_175666_e(pos, state.func_177230_c());
            chamber.clearEffect();
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180653_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
    }

    @ParametersAreNonnullByDefault
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityChamber) {
            TileEntityChamber chamber = (TileEntityChamber)tileEntity;
            if (chamber.potionEffect != null && chamber.fuelTime > 0) {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    for (int i = 0; i < 15; ++i) {
                        double d0 = (float)pos.func_177958_n() + 0.3f + rand.nextFloat() * 0.8f;
                        double d1 = (float)pos.func_177956_o() + 0.1f + rand.nextFloat() * 0.3f;
                        double d2 = (float)pos.func_177952_p() + 0.3f + rand.nextFloat() * 0.8f;
                        ArrayList effect = Lists.newArrayList();
                        effect.add(chamber.potionEffect);
                        int c = PotionUtils.func_185181_a((Collection)effect);
                        float[] rgb = Utils.getRGBComponents(c, null);
                        worldIn.func_175688_a(EnumParticleTypes.SPELL_MOB, d0 + (double)((float)facing.func_82601_c() * 0.5f), d1, d2 + (double)((float)facing.func_82599_e() * 0.5f), (double)rgb[0], (double)rgb[1], (double)rgb[2], new int[0]);
                    }
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77978_p() == null) {
            return;
        }
        NBTTagCompound chamberData = stack.func_77978_p().func_74775_l("chamberTags");
        PotionEffect activeEffect = PotionEffect.func_82722_b((NBTTagCompound)chamberData);
        int timeElapsed = chamberData.func_74762_e("activeTime") / 20;
        TextFormatting format = activeEffect.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.BLUE;
        tooltip.add("Active Effect: " + format + Utils.localizeIgnoreFormat(activeEffect.func_76453_d()));
        tooltip.add("Time Elapsed: " + timeElapsed / 60 + ":" + timeElapsed % 60);
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, FACING});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockChamber.getFacing(meta)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= BlockChamber.getMetaForFacing((EnumFacing)state.func_177229_b((IProperty)FACING));
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    private static EnumFacing getFacing(int meta) {
        switch (meta & 3) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.SOUTH;
            }
            case 2: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.EAST;
    }

    private static int getMetaForFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
        }
        return 3;
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_176213_c(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState north = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState south = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState west = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState east = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (face == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
                face = EnumFacing.SOUTH;
            } else if (face == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
                face = EnumFacing.NORTH;
            } else if (face == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
                face = EnumFacing.EAST;
            } else if (face == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
                face = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)face), 2);
        }
    }
}

