/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.block;

import com.google.common.collect.Maps;
import it.hurts.metallurgy_reforged.block.BlockMetal;
import it.hurts.metallurgy_reforged.block.BlockOre;
import it.hurts.metallurgy_reforged.block.BlockOrientable;
import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.block.gadget.BlockIceShield;
import it.hurts.metallurgy_reforged.block.gadget.BlockMetallurgyTNT;
import it.hurts.metallurgy_reforged.block.gadget.BlockPhosphorusLamp;
import it.hurts.metallurgy_reforged.block.machines.BlockAlloyer;
import it.hurts.metallurgy_reforged.block.machines.BlockChamber;
import it.hurts.metallurgy_reforged.block.machines.BlockCrusher;
import it.hurts.metallurgy_reforged.config.RegistrationConfig;
import it.hurts.metallurgy_reforged.item.ItemBlockOre;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.model.Drop;
import it.hurts.metallurgy_reforged.util.BlockUtils;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import it.hurts.metallurgy_reforged.util.Utils;
import it.hurts.metallurgy_reforged.world.explosive.ExplosiveType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;

public class ModBlocks {
    public static List<Block> miscBlocks = new ArrayList<Block>();
    public static BlockOre oreSulfur = new BlockOre("sulfur_ore", 3.0f, 1, 10.0f, null).setDrops(new Drop(new ItemStack((Item)ModItems.SULFUR, 4), 1.0f));
    public static BlockOre orePhosphorite = new BlockOre("phosphorite_ore", 3.0f, 1, 10.0f, null).setDrops(new Drop(ModItems.PHOSPHORUS, 3, 1.0f));
    public static BlockOre oreTar = new BlockOre("tar_ore", 3.0f, 1, 10.0f, null).setDrops(new Drop(ModItems.TAR, 2, 1.0f), new Drop(ModItems.BITUMEN, 2, 0.5f));
    public static BlockOre orePotash = new BlockOre("potash_ore", 3.0f, 1, 10.0f, null).setDrops(new Drop(ModItems.POTASH, 3, 1.0f));
    public static Block blockBitumen = new Block(Material.field_151576_e);
    public static Block blockCharcoal = new Block(Material.field_151576_e);
    public static Block blockSulfur = new Block(Material.field_151576_e);
    public static Block iceShield = new BlockIceShield();
    public static BlockPhosphorusLamp blockPhosphorusLamp = new BlockPhosphorusLamp();
    public static BlockOrientable blockRoad = (BlockOrientable)new BlockOrientable(Material.field_151576_e, "road_block", MetallurgyTabs.tabSpecial).func_149711_c(3.0f);
    public static BlockOrientable blockStripedRoad = (BlockOrientable)new BlockOrientable(Material.field_151576_e, "striped_road_block", MetallurgyTabs.tabSpecial).func_149711_c(3.0f);
    public static BlockCrusher crusher = new BlockCrusher("crusher");
    public static BlockAlloyer alloyer = new BlockAlloyer("alloyer");
    public static BlockChamber chamber = new BlockChamber("sublimation_chamber");
    public static BlockMetal structureBlock = new BlockMetal("bimetal_structure", BlockTypes.BLOCK){

        @Override
        public boolean func_149686_d(@Nonnull IBlockState state) {
            return false;
        }

        @Override
        public boolean func_149662_c(@Nonnull IBlockState state) {
            return false;
        }

        @Override
        @Nonnull
        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.CUTOUT;
        }
    };
    public static Map<ExplosiveType, BlockMetallurgyTNT> tntBlocks = Utils.makeDo(Maps.newEnumMap(ExplosiveType.class), tntMap -> {
        for (ExplosiveType type : ExplosiveType.values()) {
            tntMap.put(type, new BlockMetallurgyTNT(type));
        }
    });
    public static BlockMetal engravedIronBlock = new BlockMetal("iron", BlockTypes.ENGRAVED_BLOCK);
    public static BlockMetal largeIronBricks = new BlockMetal("iron", BlockTypes.LARGE_BRICKS);
    public static BlockMetal ironBricks = new BlockMetal("iron", BlockTypes.BRICKS);
    public static BlockMetal ironCrystal = new BlockMetal("iron", BlockTypes.CRYSTAL);
    public static BlockMetal ironHazardBlock = new BlockMetal("iron", BlockTypes.HAZARD_BLOCK);
    public static BlockMetal ironReinforcedGlass = new BlockMetal("iron", BlockTypes.GLASS);
    public static BlockMetal engravedGoldBlock = new BlockMetal("gold", BlockTypes.ENGRAVED_BLOCK);
    public static BlockMetal largeGoldBricks = new BlockMetal("gold", BlockTypes.LARGE_BRICKS);
    public static BlockMetal goldBricks = new BlockMetal("gold", BlockTypes.BRICKS);
    public static BlockMetal goldCrystal = new BlockMetal("gold", BlockTypes.CRYSTAL);
    public static BlockMetal goldHazardBlock = new BlockMetal("gold", BlockTypes.HAZARD_BLOCK);
    public static BlockMetal goldReinforcedGlass = new BlockMetal("gold", BlockTypes.GLASS);

    public static ItemBlock createItemBlock(Block block) {
        if (block instanceof BlockOre) {
            return (ItemBlock)new ItemBlockOre((BlockOre)block).setRegistryName(block.getRegistryName());
        }
        return (ItemBlock)new ItemBlock(block).setRegistryName(block.getRegistryName());
    }

    static {
        BlockUtils.initBlock(blockBitumen, "bitumen_block", MetallurgyTabs.tabBlock, 3.0f, 10.0f, "p", 1);
        BlockUtils.initBlock(blockCharcoal, "charcoal_block", MetallurgyTabs.tabBlock, 3.0f, 10.0f, "p", 1);
        BlockUtils.initBlock(blockSulfur, "sulfur_block", MetallurgyTabs.tabBlock, 3.0f, 10.0f, "p", 1);
        miscBlocks.add(blockBitumen);
        miscBlocks.add(blockCharcoal);
        miscBlocks.add(blockSulfur);
        miscBlocks.add(oreTar);
        miscBlocks.add(oreSulfur);
        miscBlocks.add(orePotash);
        miscBlocks.add(orePhosphorite);
        if (RegistrationConfig.categoryBlocks.enableEngravedMetalBlocks) {
            Collections.addAll(miscBlocks, engravedGoldBlock, engravedIronBlock);
        }
        if (RegistrationConfig.categoryBlocks.enableLargeBricksMetalBlocks) {
            Collections.addAll(miscBlocks, largeGoldBricks, largeIronBricks);
        }
        if (RegistrationConfig.categoryBlocks.enableBricksMetalBlocks) {
            Collections.addAll(miscBlocks, goldBricks, ironBricks);
        }
        if (RegistrationConfig.categoryBlocks.enableCrystalMetalBlocks) {
            Collections.addAll(miscBlocks, goldCrystal, ironCrystal);
        }
        if (RegistrationConfig.categoryBlocks.enableHazardMetalBlocks) {
            Collections.addAll(miscBlocks, goldHazardBlock, ironHazardBlock);
        }
        if (RegistrationConfig.categoryBlocks.enableReinforcedGlassBlocks) {
            Collections.addAll(miscBlocks, goldReinforcedGlass, ironReinforcedGlass);
        }
        miscBlocks.add(structureBlock);
        miscBlocks.add(iceShield);
        miscBlocks.addAll(tntBlocks.values());
    }
}

