/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.block;

import it.hurts.metallurgy_reforged.advancement.ModAdvancements;
import it.hurts.metallurgy_reforged.advancement.trigger.HarvestLevelTrigger;
import it.hurts.metallurgy_reforged.config.GeneralConfig;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.model.Drop;
import it.hurts.metallurgy_reforged.particle.ParticleOre;
import it.hurts.metallurgy_reforged.util.BlockUtils;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockOre
extends Block {
    private List<Drop> customDrops;
    private final MetalStats metal;

    public BlockOre(String name, float hardness, int harvestLevel, float blastResistance, MetalStats metal) {
        super(Material.field_151576_e);
        BlockUtils.initBlock(this, name, MetallurgyTabs.tabOre, hardness, blastResistance, "pickaxe", harvestLevel);
        this.metal = metal;
    }

    public MetalStats getMetalStats() {
        return this.metal;
    }

    public BlockOre setDrops(Drop ... drops) {
        this.customDrops = Arrays.asList(drops);
        return this;
    }

    @ParametersAreNonnullByDefault
    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (player instanceof EntityPlayerMP) {
            HarvestLevelTrigger.Instance wrapper = new HarvestLevelTrigger.Instance(state.func_177230_c().getHarvestLevel(state));
            ModAdvancements.Triggers.BREAK_ORE_TIER.trigger((EntityPlayerMP)player, wrapper);
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    @ParametersAreNonnullByDefault
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.customDrops != null) {
            for (Drop drop : this.customDrops) {
                if (!(Math.random() <= (double)drop.getChance())) continue;
                drops.add((Object)new ItemStack(drop.getItemStack().func_77973_b(), drop.getRandomAmount()));
            }
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean func_149659_a(@Nonnull Explosion explosionIn) {
        return Utils.random.nextInt(4) > 0;
    }

    public int getLightValue(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (GeneralConfig.enableOreLight) {
            return this.getHarvestLevel(state) >= 5 ? 5 : super.getLightValue(state, world, pos);
        }
        return super.getLightValue(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState stateIn, World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (worldIn.field_72995_K && GeneralConfig.enableOreParticles) {
            this.spawnParticles(worldIn, pos, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World worldIn, BlockPos pos, Random random) {
        double d0 = 0.0625;
        String metalName = this.getRegistryName().func_110623_a().replace("_ore", "");
        Metal metal = ModMetals.metalMap.get(metalName);
        if (metal == null) {
            return;
        }
        float[] color = metal.getStats().getColorRGBValues();
        for (int i = 0; i < 6; ++i) {
            int harvestLevel;
            double d1 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() + d0 + 1.0;
            }
            if (i == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - d0;
            }
            if (i == 2 && !worldIn.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() + d0 + 1.0;
            }
            if (i == 3 && !worldIn.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() - d0;
            }
            if (i == 4 && !worldIn.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() + d0 + 1.0;
            }
            if (i == 5 && !worldIn.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() - d0;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1)) || (harvestLevel = this.getHarvestLevel(this.func_176223_P())) <= 1) continue;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleOre(worldIn, d1, d2, d3, 1.5f, color[0], color[1], color[2], true, (int)(((float)harvestLevel - 2.0f) / 5.0f * 9.0f)));
        }
    }
}

