/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.block;

import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.util.BlockUtils;
import it.hurts.metallurgy_reforged.util.Constants;
import it.hurts.metallurgy_reforged.util.MetallurgyTabs;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMetal
extends Block {
    private final MetalStats metal;
    private final BlockTypes type;

    public BlockMetal(MetalStats metal, BlockTypes type, float hardness) {
        super(type == BlockTypes.GLASS ? Material.field_151592_s : Material.field_151573_f);
        this.metal = metal;
        this.type = type;
        this.func_149672_a(SoundType.field_185852_e);
        if (this.type == BlockTypes.GLASS) {
            this.func_149713_g(0);
        }
        BlockUtils.initBlock(this, metal.getName() + "_" + type.getPrefix(), MetallurgyTabs.tabBlock, hardness, metal.getBlockBlastResistance(), "pickaxe", 2);
    }

    public BlockMetal(String metalName, BlockTypes type) {
        super(type == BlockTypes.GLASS ? Material.field_151592_s : Material.field_151573_f);
        this.metal = Constants.EMPTY_METAL_STATS;
        this.type = type;
        this.func_149672_a(SoundType.field_185852_e);
        if (this.type == BlockTypes.GLASS) {
            this.func_149713_g(0);
        }
        BlockUtils.initBlock(this, metalName + "_" + type.getPrefix(), MetallurgyTabs.tabBlock, 3.0f, 5.0f, "pickaxe", 1);
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return this.type != BlockTypes.GLASS;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return this.type != BlockTypes.GLASS;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        if (this.type == BlockTypes.GLASS) {
            return BlockRenderLayer.CUTOUT;
        }
        return BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        IBlockState neighbourState = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block neighbourBlock = neighbourState.func_177230_c();
        if (this.type == BlockTypes.GLASS) {
            if (blockState != neighbourState) {
                return true;
            }
            if (neighbourBlock == this) {
                return false;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean isBeaconBase(@Nonnull IBlockAccess worldObj, @Nonnull BlockPos pos, @Nonnull BlockPos beacon) {
        if (this.type != BlockTypes.BLOCK) {
            return false;
        }
        if (this.metal.getOreHarvest() == -1) {
            return this.metal.getToolStats().getHarvestLevel() > 1;
        }
        return this.metal.getOreHarvest() > 1;
    }

    public MetalStats getMetalStats() {
        return this.metal;
    }

    public BlockTypes getType() {
        return this.type;
    }
}

