/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.advancement;

import it.hurts.metallurgy_reforged.advancement.CommonCriterionInstances;
import it.hurts.metallurgy_reforged.advancement.ModAdvancements;
import it.hurts.metallurgy_reforged.advancement.trigger.AdvancementGrantedTrigger;
import it.hurts.metallurgy_reforged.advancement.trigger.JackOfAllTradesTrigger;
import it.hurts.metallurgy_reforged.advancement.trigger.YinYangTrigger;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TriggerDispatcher {
    @SubscribeEvent
    public static void dispatchEquipmentTriggers(LivingEquipmentChangeEvent event) {
        if (event.getSlot().func_188453_a() != EntityEquipmentSlot.Type.ARMOR) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            boolean allDifferent;
            Metal[] wornMetals = new Metal[4];
            for (EntityEquipmentSlot entityEquipmentSlot : EntityEquipmentSlot.values()) {
                if (entityEquipmentSlot.func_188453_a() == EntityEquipmentSlot.Type.HAND) continue;
                ItemStack equip = entityEquipmentSlot != event.getSlot() ? event.getEntityLiving().func_184582_a(entityEquipmentSlot) : event.getTo();
                wornMetals[entityEquipmentSlot.func_188454_b()] = ItemUtils.getMetalFromItem(equip.func_77973_b());
            }
            boolean bl = allDifferent = Arrays.stream(wornMetals).filter(Objects::nonNull).distinct().count() == 4L;
            if (allDifferent) {
                JackOfAllTradesTrigger trigger = ModAdvancements.Triggers.JACK_OF_ALL_TRADES;
                trigger.trigger((EntityPlayerMP)event.getEntityLiving(), new CommonCriterionInstances.AlwaysTrue(trigger.func_192163_a()));
            }
            int yin = 0;
            int yang = 0;
            for (Metal metal : wornMetals) {
                if (metal == ModMetals.SANGUINITE) {
                    ++yin;
                    continue;
                }
                if (metal != ModMetals.AMORDRINE) continue;
                ++yang;
            }
            if (yin == 2 && yang == 2) {
                YinYangTrigger yinYangTrigger = ModAdvancements.Triggers.YIN_YANG;
                yinYangTrigger.trigger((EntityPlayerMP)event.getEntityLiving(), new CommonCriterionInstances.AlwaysTrue(yinYangTrigger.func_192163_a()));
            }
        }
    }

    @SubscribeEvent
    public static void dispatchKillingTriggers(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayerMP) {
            EntityPlayerMP killer = (EntityPlayerMP)event.getSource().func_76346_g();
            ItemStack enemyChestplate = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST);
            if (ItemUtils.getMetalFromItem(enemyChestplate.func_77973_b()) != null) {
                ModAdvancements.Triggers.STRONG_OPPONENT.trigger(killer, new CommonCriterionInstances.AlwaysTrue(ModAdvancements.Triggers.STRONG_OPPONENT.func_192163_a()));
            }
        }
    }

    @SubscribeEvent
    public static void dispatchAdvancementGrantedTriggers(AdvancementEvent event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            ModAdvancements.Triggers.ADVANCEMENT_GRANTED.trigger((EntityPlayerMP)event.getEntityPlayer(), new AdvancementGrantedTrigger.Instance(event.getAdvancement().func_192067_g()));
        }
    }
}

