/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.advancement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import it.hurts.metallurgy_reforged.advancement.BaseCriterionInstance;
import it.hurts.metallurgy_reforged.advancement.ModAdvancements;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public abstract class MetallurgyTrigger<T extends BaseCriterionInstance<T>>
implements ICriterionTrigger<T> {
    private final ResourceLocation resourceLocation;
    private final Map<PlayerAdvancements, Listeners<T>> listenersMap = Maps.newHashMap();

    public MetallurgyTrigger(ResourceLocation parRL) {
        this.resourceLocation = parRL;
        ModAdvancements.Triggers.ALL.add(this);
    }

    public ResourceLocation func_192163_a() {
        return this.resourceLocation;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<T> listener) {
        Listeners<T> metallurgyTrigger$listeners = this.listenersMap.get(playerAdvancementsIn);
        if (metallurgyTrigger$listeners == null) {
            metallurgyTrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listenersMap.put(playerAdvancementsIn, metallurgyTrigger$listeners);
        }
        metallurgyTrigger$listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<T> listener) {
        Listeners<T> metallurgyListeners = this.listenersMap.get(playerAdvancementsIn);
        if (metallurgyListeners != null) {
            metallurgyListeners.remove(listener);
            if (metallurgyListeners.isEmpty()) {
                this.listenersMap.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listenersMap.remove(playerAdvancementsIn);
    }

    public abstract T deserializeInstance(JsonObject var1, JsonDeserializationContext var2);

    public void trigger(EntityPlayerMP parPlayer, T instance) {
        Listeners<T> triggerListeners = this.listenersMap.get(parPlayer.func_192039_O());
        if (triggerListeners != null) {
            triggerListeners.trigger(instance);
        }
    }

    static class Listeners<T extends BaseCriterionInstance<T>> {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<T>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<T> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<T> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(T instance) {
            ArrayList list = null;
            for (ICriterionTrigger.Listener<T> listener : this.listeners) {
                if (!((BaseCriterionInstance)listener.func_192158_a()).test(instance)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }
}

