/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.gui.elements;

import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.events.GuiEvent;
import forestry.api.gui.style.ITextStyle;
import forestry.api.gui.style.TextStyleBuilder;
import forestry.book.data.IndexEntry;
import forestry.book.gui.GuiForesterBook;
import forestry.book.gui.GuiForestryBookPages;
import forestry.core.gui.elements.LabelElement;
import forestry.core.gui.elements.layouts.VerticalLayout;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IndexElement
extends VerticalLayout {
    private static final ITextStyle INDEX_STYLE = new TextStyleBuilder().unicode(true).color(0).build();

    public IndexElement(int xPos, int yPos, IndexEntry[] data) {
        super(xPos, yPos, 108);
        for (IndexEntry index : data) {
            this.add(new IndexEntryElement(index));
        }
    }

    private class IndexEntryElement
    extends LabelElement {
        private final IndexEntry data;

        public IndexEntryElement(IndexEntry data) {
            super(0, 0, -1, 9, data.title, GuiElementAlignment.TOP_LEFT, INDEX_STYLE);
            this.setWidth(this.width + LabelElement.FONT_RENDERER.func_78256_a(" > "));
            this.data = data;
            this.addSelfEventHandler(GuiEvent.DownEvent.class, event -> {
                GuiForesterBook bookGui = GuiForesterBook.getGuiScreen();
                if (bookGui instanceof GuiForestryBookPages) {
                    GuiForestryBookPages pagesGui = (GuiForestryBookPages)bookGui;
                    pagesGui.switchPage(data.page);
                }
            });
        }

        @Override
        public void drawElement(int mouseX, int mouseY) {
            boolean mouseOver = this.isMouseOver();
            boolean unicode = FONT_RENDERER.func_82883_a();
            String preFix = mouseOver ? TextFormatting.GOLD + " > " : TextFormatting.DARK_GRAY + "- ";
            FONT_RENDERER.func_78264_a(this.style.isUnicode());
            FONT_RENDERER.func_78276_b(preFix + this.text, 0, 0, this.style.getColor());
            FONT_RENDERER.func_78264_a(unicode);
        }

        @Override
        public boolean canMouseOver() {
            return true;
        }
    }
}

