/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.thaumicjei.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="thaumicjei")
public class ThaumicConfig {
    @Config.RequiresMcRestart
    @Config.Comment(value={"Allow the scanning of all items in game to show what items can make aspects. WARNING: This can be performance heavy but it won't add load time to the pack, everything is done in a new thread and it might take a while to appear in game!"})
    public static boolean enableAspectFromItemStacks = true;
    @Config.RequiresMcRestart
    @Config.Comment(value={"Items blacklisted from the checking in the Aspect For ItemStack. Format: 'minecraft:stone'"})
    public static String[] blacklistedFromAspectChecking = new String[0];
    @Config.Comment(value={"If true the Aspect from ItemStack json will be created always on startup, if false if will be only be created if it doesn't exist"})
    public static boolean alwaysRecreateAspectFromItemStackFile = true;
    @Config.Comment(value={"Allow to render the ItemStacks aspects in all GUI"})
    public static boolean forceAspectTooltipInAllGUI = true;
    @Config.Comment(value={"Hide recipes from JEI if you don't have the research for it"})
    public static boolean hideRecipesIfMissingResearch = false;

    @Mod.EventBusSubscriber(modid="thaumicjei")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("thaumicjei")) {
                ConfigManager.sync((String)"thaumicjei", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

